<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Rest_Luhn extends Controller_Rest{

    public function action_index(){
        $response = [];
        $model = $this->filter($this->post);
        $model_clone = clone $model;
        $model = $this->paginate($response, $model, 20)
            ->order($this->post['sortField'], $this->post['reverse'] ? 'DESC': 'ASC') // default: id desc
            ->execute()['data'];

        if($model) {
            foreach ($model as $record) {
                $client = ORM::factory('Client', $record['client_id']);
                $unique = ORM::factory('Luhn_Unique', $record['number']);
                $response['data'][] = [
                    'id' => $record['id'],
                    'number' => intval($record['number']),
                    'client' => $client->getClientID(),
                    'location' => $client->location,
                    'prefix' => $client->prefix,
                    'referrer' => Model_Logpost::getReferer($record['id']),
                    'datetime' => Model_Logpost::getDatetime($record['id']),
                    'valid' => (!is_null($unique->valid) && $unique->loaded()) ? ($unique->valid == 't' ? true : false) : null,
                    'comment' => $unique->comment,
                ];
            }

            $model_clone->group_by('number');
            $response['unique'] = $model_clone->execute()['total_info']['total_found'];
        }

        $this->response->body(
            json_encode($response)
        );
    }

    public function action_unique(){
        if(is_array($this->post['id'])){
            foreach ($this->post['id'] as $id){
                $this->insert_unique($id);
            }
        }elseif(is_int($this->post['id'])){
            $this->insert_unique($this->post['id']);
        }
    }

    private function insert_unique($id){
        $model = ORM::factory('Luhn_Unique', $id); // number
        $model->values(Arr::extract($this->post, ['id', 'valid', 'comment']));
        $model->id = $id;
        if(empty($this->post['valid'])){
            $model->valid = NULL;
        }
        $model->save();
    }

    private function filter($post){
        $sphinxql = new SphinxQL();
        $query = $sphinxql->new_query()->add_index('luhn');

        if (Arr::get($post, 'client')) {
            $client_id = Model_Client::getClientInfo(Arr::get($post, 'client'))['id'];
            $query->where('client_id', $client_id);
        }

        /* START - END */
        if (Arr::get($post, 'date_start') && Arr::get($post, 'date_end')) {
            $start = strtotime($post['date_start']);
            $end = strtotime($post['date_end']);
            $end = strtotime("+1 day", $end);
            $query->where('datetime', $start.' AND '.$end, 'BETWEEN');
        }

        /* COUNTRY ACCESS */
        $post['country_access'] = Auth::instance()->get_user()->getCountryAccess();
        if (Arr::get($post, 'country_access')) {
            $locations = array_map(['Task_Helper', 'locationToInt'], $post['country_access']);
            /* LOCATIONS */
            if(Arr::get($post, 'locations')){
                $locations = array_intersect($locations, array_map(['Task_Helper', 'locationToInt'], $post['locations']));
            }
            $query->where_in('location', $locations ?: 0);
            unset($locations);
        }else{
            /* LOCATIONS */
            if(Arr::get($post, 'locations')){
                $query->where_in('location', array_map(['Task_Helper', 'locationToInt'], $post['locations']));
            }
        }

        /* REFERRER */
        if (Arr::get($post, 'referrer')) {
            $referrerOr = $post['referrer'];
            $referrerOr = explode('|', $referrerOr);
            $referrersEscaped = [];
            foreach($referrerOr as $referrer) {
                $referrer = Helper::EscapeSphinxQL($referrer);
                $referrersEscaped[] = Helper::wrapWithWildcardsAndOptimize($referrer);
            }
            $query->search("@referer (" . implode(')|(', $referrersEscaped) . ")");
        }

        if(isset($post['valid']) && !empty($post['valid'])){
            $ids = ORM::factory('Luhn_Unique')
                ->where('valid', '=', $post['valid'])
                ->find_all()
                ->as_array(null, 'id');

            // TODO if ids is empty & execute query, return false
            $query->where_in('number', $ids);
        }

        return $query;
    }
}